# 1 "constval-ext.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "constval-ext.c"
# 1 "config.h" 1
# 2 "constval-ext.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "constval-ext.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "constval-ext.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 8 "constval-ext.c" 2


# 1 "const.h" 1
# 11 "constval-ext.c" 2
# 1 "nlltypes.h" 1



typedef long integer_t;

typedef struct line *line_t;
typedef struct command *command_t;
typedef struct label *label_t;
typedef struct value *value_t;
typedef struct string *string_t;
typedef struct variable *variable_t;
typedef struct element *element_t;
typedef struct position *position_t;
typedef struct array *array_t;
typedef struct area *area_t;
typedef struct stack_frame *stack_frame_t;
typedef const struct function *function_t;

typedef struct spot {
  line_t line;
  command_t command;
} *spot_t;

typedef enum {
  POSITION_TYPE_NONE = 0,
  POSITION_TYPE_LOOP,
  POSITION_TYPE_FOR,
  POSITION_TYPE_IF,
  POSITION_TYPE_GOSUB,
  POSITION_TYPE_LABEL,
  POSITION_TYPE_EVAL,
} position_type_t;

typedef int function_type_t;

struct function {
  const char *name;
  const char *other_name;
  function_type_t type;
  int (*function)(value_t *valuep, value_t args);
  unsigned int flags;

};
# 12 "constval-ext.c" 2
# 1 "value.h" 1



typedef enum {
  VALUE_TYPE_UNDEFINED = 0,
  VALUE_TYPE_NULL,
  VALUE_TYPE_VALUE,
  VALUE_TYPE_VECTOR,
  VALUE_TYPE_INTEGER,
  VALUE_TYPE_STRING,

  VALUE_TYPE_FLOAT,

  VALUE_TYPE_ARRAY,
  VALUE_TYPE_AREA,
  VALUE_TYPE_POINTER,
  VALUE_TYPE_FUNCTION,
  VALUE_TYPE_LABEL,

  VALUE_TYPE_NUM
} value_type_t;

struct value {
  struct value *next;
  value_type_t type;
  int refcount;
  int procid;
  unsigned int flags;



  union {
    value_t value;
    integer_t integer;
    string_t string;

    double floating;

    struct {
      array_t a;
      int offset;
    } array;
    area_t area;
    struct {
      value_t point;
      int offset;
    } pointer;
    function_t function;
    label_t label;
  } val;
};

int value_check(void);
int value_alloc(value_t *valuep);
int value_free(value_t value);
int value_init(void);
int value_done(void);
int value_clear(value_t value);
int value_typecode(value_t value);
const char *value_typename_string(value_type_t type);
const char *value_typename(value_t value);
int value_is_true(value_t value);
value_t value_entity(value_t value);
int value_insert_value(value_t *valuep);
int value_extend_value(value_t *valuep);
int value_shrink_value(value_t *valuep);
int value_match_values(value_t *valuep, int num);
int value_cmp_value(value_t value0, value_t value1);
int value_cmp_values(value_t value0, value_t value1);
int value_copy_value(value_t dvalue, value_t svalue);
int value_copy_values(value_t *dvaluep, value_t svalue);
int value_copy_values_novector(value_t *dvaluep, value_t svalue);
value_type_t value_get_type(value_t value);
unsigned int value_get_flags(value_t value);
int value_set_flags(value_t value, unsigned int flags);
int value_reset_flags(value_t value, unsigned int flags);
int value_size(value_t value);
int value_is_same(value_t value0, value_t value1);
int value_chain_to_vector(value_t *valuep);
int value_vector_to_chain(value_t *valuep);
int value_value_to_vector(value_t value);
int value_vector_to_value(value_t value);
int value_set_next(value_t value, value_t _value);
int value_set_null(value_t value);
int value_get_value(value_t value, value_t *valuep);
int value_set_value(value_t value, value_t _value);
int value_set_values(value_t value, value_t _value);
int value_get_vector(value_t value, value_t *valuep);
int value_set_vector(value_t value, value_t _value);
int value_get_integer(value_t value, integer_t *integerp);
int value_set_integer(value_t value, integer_t integer);
int value_get_string(value_t value, char **stringp, int *lengthp);
int value_set_string(value_t value, const char *string, int length);

int value_get_float(value_t value, double *floatingp);
int value_set_float(value_t value, double floating);

int value_get_array(value_t value, array_t *arrayp, int *offsetp);
int value_set_array(value_t value, array_t array, int offset);
int value_get_area(value_t value, area_t *areap);
int value_set_area(value_t value, area_t area);
int value_get_pointer(value_t value, value_t *pointp, int *offsetp);
int value_set_pointer(value_t value, value_t point, int offset);
int value_get_function(value_t value, function_t *functionp);
int value_set_function(value_t value, function_t function);
int value_get_label(value_t value, label_t *labelp);
int value_set_label(value_t value, label_t label);
int value_get_integer_float(value_t value, integer_t *integerp);

int value_get_float_integer(value_t value, double *floatingp);

int value_output_value(FILE *fp, value_t value);
int value_output_values(FILE *fp, value_t value, const char *separator);
int value_dump_value(FILE *fp, value_t value);
int value_dump(FILE *fp, value_t value);
# 13 "constval-ext.c" 2
# 1 "constval.h" 1



struct const_variable {
  const char *name;
  unsigned int flags;
  value_type_t type;
  integer_t integer;
  const char *string;
  void *pointer;
};

extern const struct const_variable const_variables[];

extern const double const_variables_floating[];
# 14 "constval-ext.c" 2
# 1 "constval-ext.h" 1
# 15 "constval-ext.c" 2
