# 1 "charset-font8x8.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "charset-font8x8.c"
# 1 "config.h" 1
# 2 "charset-font8x8.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "charset-font8x8.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "charset-font8x8.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 8 "charset-font8x8.c" 2


# 1 "const.h" 1
# 11 "charset-font8x8.c" 2
# 1 "image.h" 1



typedef unsigned int image_draw_count_t;

typedef enum {
  IMAGE_TYPE_NONE = -1,


  IMAGE_TYPE_FULLCOLOR = 0,
  IMAGE_TYPE_MONOCOLOR,
  IMAGE_TYPE_MONOBCOLOR,
  IMAGE_TYPE_BASICCOLOR,
  IMAGE_TYPE_ROUGHCOLOR,
  IMAGE_TYPE_GRAYCOLOR,
  IMAGE_TYPE_HALFCOLOR,
} image_type_t;

typedef enum {
  IMAGE_STATUS_NONE = 0,
  IMAGE_STATUS_ACTIVE,
  IMAGE_STATUS_FREE,
} image_status_t;

typedef struct image *image_t;

struct image_procs {
  int bytesize;
  int (*index)(image_t image, int width, int x, int y, int *indexp, int *offsetp);
  int (*get_color)(image_t image, int x, int y);
  int (*set_color)(image_t image, int x, int y, int color, unsigned int flags);
  int (*copy_get_color)(image_t image, int x, int y);
  int (*copy_save)(image_t image, int x, int y, int width, int height);
  int (*copy_save_color)(image_t image, int x, int y);
};

union image_bitmap {
  void *p;
  int *word;
  unsigned char *byte;
  unsigned short *half;
};

struct image {
  int index;
  int width;
  int height;
  int size;
  image_type_t type;
  unsigned int flags;
  struct {
    int fg;
    int bg;
    int from;
    int to;
  } color;
  struct {
    int x;
    int y;
    int width;
    int height;
    int mulx;
    int muly;
  } range;
  struct {
    int x;
    int y;
  } offset;
  struct {
    struct {
      int x;
      int y;
    } mul;
    struct {
      int x;
      int y;
    } div;
  } scale;
  struct {
    int x;
    int y;
    int width;
    int height;
  } dot;
  struct {
    int x;
    int y;
    int color;
  } current;
  union image_bitmap bitmap;
  volatile image_status_t status;
  struct image_draw {
    image_draw_count_t count;
    image_draw_count_t *line;
    int column_per;
    int column_num;
    image_draw_count_t *column;
    image_draw_count_t *pixel;
  } draw;
  struct image_copy {
    union image_bitmap bitmap;
  } copy;
  struct image_procs *procs;
};

int image_init(void);
int image_done(void);
int image_check(void);
int image_is_draw_line(image_t image, image_draw_count_t count, int y);
int image_is_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_is_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_line(image_t image, image_draw_count_t count, int y);
int image_set_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_get_color(image_t image, int x, int y);
int image_set_color(image_t image, int x, int y, int color, unsigned int flags);
int image_copy_save(image_t image, int x, int y, int width, int height);
int image_copy_get_color(image_t image, int x, int y);
int image_copy_save_color(image_t image, int x, int y);
int image_get_index(image_t image);
image_t image_get_image(int index);
int image_reset_draw(image_t image);
int image_destroy(image_t image);
int image_create(image_t image, int width, int height, void *bitmap,
   image_type_t type, unsigned int flags);
image_t image_get(int width, int height, void *bitmap,
    image_type_t type, unsigned int flags);
# 12 "charset-font8x8.c" 2
# 1 "charset.h" 1
# 10 "charset.h"
struct charset {
  int width;
  int height;
  int num;

  void *bitmap;

  image_type_t type;
  unsigned int flags;
};

struct charsets {
  int type;
  const struct charset *charset;
  image_t image;
};

extern const struct charset charset_font8x8;
extern const struct charset charset_font16x16;
extern const struct charset charset_font5x5;
extern const struct charset charset_character;
extern const struct charset charset_character_2;
extern const struct charset charset_character_3;

extern struct charsets charsets[];

extern int charsets_num;
# 13 "charset-font8x8.c" 2




static unsigned char bitmap[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x00,
  0x36, 0x36, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x24, 0x7e, 0x24, 0x24, 0x7e, 0x24, 0x00,
  0x08, 0x3e, 0x09, 0x3e, 0x48, 0x3e, 0x08, 0x00,
  0x42, 0x25, 0x12, 0x08, 0x24, 0x52, 0x21, 0x00,
  0x1e, 0x23, 0x16, 0x0c, 0x56, 0x23, 0x5e, 0x00,
  0x18, 0x18, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00,
  0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00,
  0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00,
  0x08, 0x2a, 0x1c, 0x08, 0x1c, 0x2a, 0x08, 0x00,
  0x00, 0x08, 0x08, 0x3e, 0x08, 0x08, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x10, 0x08,
  0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00,
  0x40, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03, 0x00,

  0x3e, 0x43, 0x47, 0x4b, 0x53, 0x63, 0x3e, 0x00,
  0x18, 0x1c, 0x1e, 0x18, 0x18, 0x18, 0x7e, 0x00,
  0x3e, 0x61, 0x30, 0x18, 0x0c, 0x06, 0x7f, 0x00,
  0x3e, 0x61, 0x60, 0x3c, 0x60, 0x61, 0x3e, 0x00,
  0x38, 0x34, 0x32, 0x31, 0x7f, 0x30, 0x30, 0x00,
  0x3f, 0x03, 0x03, 0x3f, 0x40, 0x41, 0x3e, 0x00,
  0x3e, 0x03, 0x03, 0x3f, 0x43, 0x43, 0x3e, 0x00,
  0x7f, 0x63, 0x60, 0x60, 0x30, 0x18, 0x0c, 0x00,
  0x3e, 0x43, 0x43, 0x3e, 0x43, 0x43, 0x3e, 0x00,
  0x3e, 0x61, 0x61, 0x7e, 0x60, 0x60, 0x3e, 0x00,

  0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00,
  0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x10, 0x08,
  0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00,
  0x00, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x00, 0x00,
  0x06, 0x0c, 0x18, 0x30, 0x18, 0x0c, 0x06, 0x00,
  0x3c, 0x42, 0x42, 0x30, 0x18, 0x00, 0x18, 0x00,
  0x1c, 0x22, 0x49, 0x55, 0x29, 0x02, 0x3c, 0x00,

  0x08, 0x1c, 0x26, 0x43, 0x7f, 0x43, 0x43, 0x00,
  0x3f, 0x43, 0x43, 0x3f, 0x43, 0x43, 0x3f, 0x00,
  0x3c, 0x46, 0x03, 0x03, 0x03, 0x46, 0x3c, 0x00,
  0x1f, 0x23, 0x43, 0x43, 0x43, 0x23, 0x1f, 0x00,
  0x7f, 0x03, 0x03, 0x3f, 0x03, 0x03, 0x7f, 0x00,
  0x7f, 0x03, 0x03, 0x3f, 0x03, 0x03, 0x03, 0x00,
  0x3c, 0x46, 0x03, 0x73, 0x43, 0x46, 0x3c, 0x00,
  0x43, 0x43, 0x43, 0x7f, 0x43, 0x43, 0x43, 0x00,
  0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00,
  0x78, 0x30, 0x30, 0x30, 0x32, 0x32, 0x1c, 0x00,
  0x43, 0x23, 0x13, 0x0f, 0x13, 0x23, 0x43, 0x00,
  0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x7f, 0x00,
  0x43, 0x7f, 0x5b, 0x5b, 0x43, 0x43, 0x43, 0x00,
  0x43, 0x47, 0x4b, 0x53, 0x63, 0x43, 0x43, 0x00,
  0x1c, 0x22, 0x43, 0x43, 0x43, 0x22, 0x1c, 0x00,
  0x3f, 0x43, 0x43, 0x3f, 0x03, 0x03, 0x03, 0x00,
  0x1c, 0x22, 0x43, 0x43, 0x5b, 0x26, 0x5c, 0x00,
  0x3f, 0x43, 0x43, 0x3f, 0x13, 0x23, 0x43, 0x00,
  0x3e, 0x43, 0x03, 0x3e, 0x40, 0x41, 0x3e, 0x00,
  0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,
  0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x3e, 0x00,
  0x43, 0x43, 0x43, 0x43, 0x22, 0x14, 0x08, 0x00,
  0x43, 0x43, 0x43, 0x4b, 0x4b, 0x2a, 0x14, 0x00,
  0x43, 0x26, 0x1c, 0x18, 0x34, 0x62, 0x41, 0x00,
  0x43, 0x26, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x00,
  0x7f, 0x60, 0x34, 0x18, 0x1c, 0x06, 0x7f, 0x00,

  0x18, 0x08, 0x08, 0x08, 0x08, 0x08, 0x18, 0x00,
  0x01, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00,
  0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x00,
  0x08, 0x1c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00,
  0x0c, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x1c, 0x26, 0x26, 0x26, 0x5c, 0x00,
  0x00, 0x06, 0x06, 0x3e, 0x46, 0x46, 0x3e, 0x00,
  0x00, 0x00, 0x3c, 0x46, 0x06, 0x46, 0x3c, 0x00,
  0x00, 0x60, 0x60, 0x7c, 0x62, 0x62, 0x7c, 0x00,
  0x00, 0x00, 0x3c, 0x46, 0x7e, 0x06, 0x3c, 0x00,
  0x00, 0x30, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00,
  0x00, 0x00, 0x3c, 0x62, 0x62, 0x7c, 0x60, 0x3c,
  0x00, 0x06, 0x06, 0x3e, 0x46, 0x46, 0x46, 0x00,
  0x00, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00,
  0x00, 0x30, 0x00, 0x30, 0x30, 0x30, 0x34, 0x18,
  0x00, 0x06, 0x46, 0x26, 0x1e, 0x26, 0x46, 0x00,
  0x00, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,
  0x00, 0x00, 0x2b, 0x56, 0x56, 0x56, 0x56, 0x00,
  0x00, 0x00, 0x3b, 0x46, 0x46, 0x46, 0x46, 0x00,
  0x00, 0x00, 0x3c, 0x46, 0x46, 0x46, 0x3c, 0x00,
  0x00, 0x00, 0x3c, 0x46, 0x3e, 0x06, 0x06, 0x00,
  0x00, 0x00, 0x3c, 0x62, 0x7c, 0x60, 0x60, 0x00,
  0x00, 0x00, 0x3e, 0x46, 0x06, 0x06, 0x06, 0x00,
  0x00, 0x00, 0x3c, 0x06, 0x3c, 0x40, 0x3c, 0x00,
  0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x00,
  0x00, 0x00, 0x26, 0x26, 0x26, 0x26, 0x5c, 0x00,
  0x00, 0x00, 0x46, 0x46, 0x46, 0x3c, 0x18, 0x00,
  0x00, 0x00, 0x46, 0x46, 0x56, 0x56, 0x2c, 0x00,
  0x00, 0x00, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x00,
  0x00, 0x00, 0x62, 0x62, 0x62, 0x7c, 0x60, 0x3c,
  0x00, 0x00, 0x7e, 0x30, 0x18, 0x0c, 0x7e, 0x00,

  0x10, 0x08, 0x08, 0x04, 0x08, 0x08, 0x10, 0x00,
  0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,
  0x04, 0x08, 0x08, 0x10, 0x08, 0x08, 0x04, 0x00,
  0x4c, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,


  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

};

const struct charset charset_font8x8 = {
  8, 8,
  sizeof(bitmap) / (sizeof(*bitmap) * 8),
  bitmap, IMAGE_TYPE_MONOBCOLOR, (1 << 9)
};
