# 1 "charset-font16x16.c"
# 1 "/tmp/nlux/nll//"
# 1 "<built-in>"
# 1 "<command-line>"
# 1 "charset-font16x16.c"
# 1 "config.h" 1
# 2 "charset-font16x16.c" 2

# 1 "../include/stdio.h" 1



# 1 "../include/sys/types.h" 1



typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int int32_t;
typedef unsigned int uint32_t;
typedef short int16_t;
typedef unsigned short uint16_t;
typedef char int8_t;
typedef unsigned char uint8_t;

typedef unsigned long size_t;
typedef unsigned long ssize_t;
typedef uint16_t mode_t;

typedef int pid_t;
typedef unsigned int uid_t;
typedef unsigned int gid_t;

typedef long intptr_t;

typedef __builtin_va_list __va_list;







typedef long off_t;
typedef long useconds_t;
# 5 "../include/stdio.h" 2



typedef struct __nllibc_FILE FILE;

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

int feof(FILE *stream);
int ferror(FILE *stream);
int fileno(FILE *stream);
FILE *fopen(const char *path, const char *mode);
FILE *fdopen(int fildes, const char *mode);
int fclose(FILE *stream);
int vsprintf(char *str, const char *format, __va_list ap);
int vfprintf(FILE *stream, const char *format, __va_list ap);
int vprintf(const char *format, __va_list ap);
int sprintf(char *str, const char *format, ...);
int fprintf(FILE *stream, const char *format, ...);
int printf(const char *format, ...);
int fgetc(FILE *stream);
int fputc(int c, FILE *stream);
int puts(const char *str);
char *fgets(char *str, int size, FILE *stream);
int fputs(const char *str, FILE *stream);
int fflush(FILE *stream);
size_t fread(void *ptr, size_t size, size_t nmemb, FILE *stream);
size_t fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream);
int fseek(FILE *stream, long offset, int whence);

int rename(const char *from, const char *to);
# 4 "charset-font16x16.c" 2
# 1 "../include/stdlib.h" 1







void *malloc(size_t size);
void *calloc(size_t number, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);
void exit(int status);
void abort(void);
int atexit(void (*function)(void));

int atoi(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
# 5 "charset-font16x16.c" 2


# 1 "../include/nllibc/nllibc.h" 1
# 102 "../include/nllibc/nllibc.h"
int __nllibc_memory_stat(int *alloc_sizep, int *alloc_countp, int *free_sizep);
# 8 "charset-font16x16.c" 2


# 1 "const.h" 1
# 11 "charset-font16x16.c" 2
# 1 "image.h" 1



typedef unsigned int image_draw_count_t;

typedef enum {
  IMAGE_TYPE_NONE = -1,


  IMAGE_TYPE_FULLCOLOR = 0,
  IMAGE_TYPE_MONOCOLOR,
  IMAGE_TYPE_MONOBCOLOR,
  IMAGE_TYPE_BASICCOLOR,
  IMAGE_TYPE_ROUGHCOLOR,
  IMAGE_TYPE_GRAYCOLOR,
  IMAGE_TYPE_HALFCOLOR,
} image_type_t;

typedef enum {
  IMAGE_STATUS_NONE = 0,
  IMAGE_STATUS_ACTIVE,
  IMAGE_STATUS_FREE,
} image_status_t;

typedef struct image *image_t;

struct image_procs {
  int bytesize;
  int (*index)(image_t image, int width, int x, int y, int *indexp, int *offsetp);
  int (*get_color)(image_t image, int x, int y);
  int (*set_color)(image_t image, int x, int y, int color, unsigned int flags);
  int (*copy_get_color)(image_t image, int x, int y);
  int (*copy_save)(image_t image, int x, int y, int width, int height);
  int (*copy_save_color)(image_t image, int x, int y);
};

union image_bitmap {
  void *p;
  int *word;
  unsigned char *byte;
  unsigned short *half;
};

struct image {
  int index;
  int width;
  int height;
  int size;
  image_type_t type;
  unsigned int flags;
  struct {
    int fg;
    int bg;
    int from;
    int to;
  } color;
  struct {
    int x;
    int y;
    int width;
    int height;
    int mulx;
    int muly;
  } range;
  struct {
    int x;
    int y;
  } offset;
  struct {
    struct {
      int x;
      int y;
    } mul;
    struct {
      int x;
      int y;
    } div;
  } scale;
  struct {
    int x;
    int y;
    int width;
    int height;
  } dot;
  struct {
    int x;
    int y;
    int color;
  } current;
  union image_bitmap bitmap;
  volatile image_status_t status;
  struct image_draw {
    image_draw_count_t count;
    image_draw_count_t *line;
    int column_per;
    int column_num;
    image_draw_count_t *column;
    image_draw_count_t *pixel;
  } draw;
  struct image_copy {
    union image_bitmap bitmap;
  } copy;
  struct image_procs *procs;
};

int image_init(void);
int image_done(void);
int image_check(void);
int image_is_draw_line(image_t image, image_draw_count_t count, int y);
int image_is_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_is_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_line(image_t image, image_draw_count_t count, int y);
int image_set_draw_column(image_t image, image_draw_count_t count, int x, int y);
int image_set_draw_pixel(image_t image, image_draw_count_t count, int x, int y);
int image_get_color(image_t image, int x, int y);
int image_set_color(image_t image, int x, int y, int color, unsigned int flags);
int image_copy_save(image_t image, int x, int y, int width, int height);
int image_copy_get_color(image_t image, int x, int y);
int image_copy_save_color(image_t image, int x, int y);
int image_get_index(image_t image);
image_t image_get_image(int index);
int image_reset_draw(image_t image);
int image_destroy(image_t image);
int image_create(image_t image, int width, int height, void *bitmap,
   image_type_t type, unsigned int flags);
image_t image_get(int width, int height, void *bitmap,
    image_type_t type, unsigned int flags);
# 12 "charset-font16x16.c" 2
# 1 "charset.h" 1
# 10 "charset.h"
struct charset {
  int width;
  int height;
  int num;

  void *bitmap;

  image_type_t type;
  unsigned int flags;
};

struct charsets {
  int type;
  const struct charset *charset;
  image_t image;
};

extern const struct charset charset_font8x8;
extern const struct charset charset_font16x16;
extern const struct charset charset_font5x5;
extern const struct charset charset_character;
extern const struct charset charset_character_2;
extern const struct charset charset_character_3;

extern struct charsets charsets[];

extern int charsets_num;
# 13 "charset-font16x16.c" 2




static int bitmap[] = {

  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,0x0000,0x03c0,0x03c0,0x0000,
  0x0000,0x0c30,0x1e78,0x1e78,0x1c70,0x1c70,0x0e38,0x071c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0c30,0x0c30,0x3ffc,0x3ffc,0x0c30,0x0c30,0x0c30,0x0c30,0x3ffc,0x3ffc,0x0c30,0x0c30,0x0000,0x0000,
  0x0000,0x0180,0x0180,0x3ff8,0x3ffc,0x018e,0x018e,0x1ffc,0x3ff8,0x7180,0x7180,0x3ffc,0x1ffc,0x0180,0x0180,0x0000,
  0x0000,0x6018,0x703c,0x3866,0x1c66,0x0e3c,0x0718,0x0380,0x01c0,0x18e0,0x3c70,0x6638,0x661c,0x3c0e,0x1806,0x0000,
  0x0000,0x07f8,0x0ffc,0x0c0c,0x0e0c,0x071c,0x03b8,0x01f0,0x00e0,0x31f0,0x3bb8,0x1f1c,0x0e1c,0x3ff8,0x3bf0,0x0000,
  0x0000,0x0180,0x03c0,0x03c0,0x0380,0x0380,0x01c0,0x00e0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0300,0x0380,0x0180,0x01c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x01c0,0x0180,0x0380,0x0300,0x0000,
  0x0000,0x00c0,0x01c0,0x0180,0x0380,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0380,0x0180,0x01c0,0x00c0,0x0000,
  0x0000,0x0180,0x0180,0x399c,0x1db8,0x0ff0,0x07e0,0x03c0,0x03c0,0x07e0,0x0ff0,0x1db8,0x399c,0x0180,0x0180,0x0000,
  0x0000,0x0000,0x0000,0x0180,0x0180,0x0180,0x0180,0x1ff8,0x1ff8,0x0180,0x0180,0x0180,0x0180,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x03c0,0x03c0,0x0380,0x0380,0x01c0,0x00e0,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1ff8,0x1ff8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0180,0x03c0,0x03c0,0x0180,0x0000,0x0000,
  0x0000,0x6000,0x7000,0x3800,0x1c00,0x0e00,0x0700,0x0380,0x01c0,0x00e0,0x0070,0x0038,0x001c,0x000e,0x0006,0x0000,

  0x0000,0x1ff8,0x3ffc,0x7c3e,0x781e,0x787e,0x78fe,0x79de,0x7b9e,0x7f1e,0x7e1e,0x781e,0x7c3e,0x3ffc,0x1ff8,0x0000,
  0x0000,0x0380,0x03c0,0x03e0,0x03f0,0x03f8,0x03fc,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x3ffc,0x3ffc,0x0000,
  0x0000,0x1ff8,0x3ffc,0x783e,0x781e,0x3c00,0x1e00,0x0f00,0x0780,0x03c0,0x01e0,0x00f0,0x0078,0x7ffc,0x7ffe,0x0000,
  0x0000,0x1ff8,0x3ffc,0x781e,0x781e,0x7800,0x7800,0x3fe0,0x3fe0,0x7800,0x7800,0x781e,0x781e,0x3ffc,0x1ff8,0x0000,
  0x0000,0x1e00,0x1f00,0x1f80,0x1fc0,0x1ee0,0x1e70,0x1e38,0x1e1c,0x7ffe,0x7ffe,0x1e00,0x1e00,0x1e00,0x1e00,0x0000,
  0x0000,0x1ffe,0x1ffe,0x001e,0x001e,0x001e,0x001e,0x1ffe,0x3ffe,0x7c00,0x7800,0x781e,0x7c3e,0x3ffc,0x1ff8,0x0000,
  0x0000,0x1ff8,0x1ffc,0x001e,0x001e,0x001e,0x001e,0x1ffe,0x3ffe,0x781e,0x781e,0x781e,0x781e,0x3ffc,0x1ff8,0x0000,
  0x0000,0x7ffe,0x7ffe,0x781e,0x781e,0x7800,0x7800,0x7800,0x7c00,0x3e00,0x1f00,0x0f80,0x07c0,0x03e0,0x01e0,0x0000,
  0x0000,0x1ff8,0x3ffc,0x7c3e,0x781e,0x781e,0x3c3c,0x1ff8,0x1ff8,0x3c3c,0x781e,0x781e,0x7c3e,0x3ffc,0x1ff8,0x0000,
  0x0000,0x1ff8,0x3ffc,0x7c3e,0x781e,0x781e,0x7c3e,0x7ffc,0x7ff8,0x7800,0x7800,0x7800,0x7c00,0x3ff8,0x1ff8,0x0000,

  0x0000,0x0000,0x0180,0x03c0,0x03c0,0x0180,0x0000,0x0000,0x0000,0x0000,0x0180,0x03c0,0x03c0,0x0180,0x0000,0x0000,
  0x0000,0x0000,0x0180,0x03c0,0x03c0,0x0180,0x0000,0x0000,0x0000,0x0180,0x03c0,0x03c0,0x0180,0x0180,0x00c0,0x0000,
  0x0000,0x1e00,0x0f00,0x0780,0x03c0,0x01e0,0x00f0,0x0078,0x0078,0x00f0,0x01e0,0x03c0,0x0780,0x0f00,0x1e00,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x1ff8,0x1ff8,0x0000,0x0000,0x1ff8,0x1ff8,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0078,0x00f0,0x01e0,0x03c0,0x0780,0x0f00,0x1e00,0x1e00,0x0f00,0x0780,0x03c0,0x01e0,0x00f0,0x0078,0x0000,
  0x0000,0x0ff0,0x1ff8,0x381c,0x300c,0x300c,0x380c,0x1f00,0x0f80,0x0180,0x0000,0x0180,0x03c0,0x03c0,0x0180,0x0000,
  0x0000,0x07e0,0x0ff0,0x1c38,0x381c,0x718e,0x63c6,0x6666,0x7666,0x3fc6,0x198e,0x001c,0x0038,0x1ff0,0x1fe0,0x0000,

  0x0000,0x0180,0x03c0,0x07e0,0x0ff0,0x1e78,0x3c3c,0x781e,0x781e,0x7ffe,0x7ffe,0x781e,0x781e,0x781e,0x781e,0x0000,
  0x0000,0x1ffe,0x3ffe,0x7c1e,0x781e,0x781e,0x3c1e,0x1ffe,0x1ffe,0x3c1e,0x781e,0x781e,0x7c1e,0x3ffe,0x1ffe,0x0000,
  0x0000,0x1fe0,0x3ff0,0x7c78,0x783c,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x783c,0x7c78,0x3ff0,0x1fe0,0x0000,
  0x0000,0x0ffe,0x1ffe,0x3c1e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x3c1e,0x1ffe,0x0ffe,0x0000,
  0x0000,0x7ffe,0x7ffe,0x001e,0x001e,0x001e,0x001e,0x1ffe,0x1ffe,0x001e,0x001e,0x001e,0x001e,0x7ffe,0x7ffe,0x0000,
  0x0000,0x7ffe,0x7ffe,0x001e,0x001e,0x001e,0x001e,0x1ffe,0x1ffe,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x0000,
  0x0000,0x1fe0,0x3ff0,0x7c78,0x783c,0x001e,0x001e,0x7e1e,0x7e1e,0x781e,0x781e,0x783c,0x7c78,0x3ff0,0x1fe0,0x0000,
  0x0000,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x7ffe,0x7ffe,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x0000,
  0x0000,0x0ff0,0x0ff0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0ff0,0x0ff0,0x0000,
  0x0000,0x7f80,0x7f80,0x1e00,0x1e00,0x1e00,0x1e00,0x1e00,0x1e00,0x1e1e,0x1e1e,0x1e1e,0x1f3e,0x0ffc,0x03f0,0x0000,
  0x0000,0x781e,0x3c1e,0x1e1e,0x0f1e,0x079e,0x03de,0x01fe,0x01fe,0x03de,0x079e,0x0f1e,0x1e1e,0x3c1e,0x781e,0x0000,
  0x0000,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x7ffe,0x7ffe,0x0000,
  0x0000,0x781e,0x7c3e,0x7e7e,0x7ffe,0x7ffe,0x7bde,0x799e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x0000,
  0x0000,0x781e,0x783e,0x787e,0x78fe,0x79de,0x7b9e,0x7f1e,0x7e1e,0x7c1e,0x781e,0x781e,0x781e,0x781e,0x781e,0x0000,
  0x0000,0x07e0,0x0ff0,0x1c38,0x381c,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x381c,0x1c38,0x0ff0,0x07e0,0x0000,
  0x0000,0x1ffe,0x3ffe,0x7c1e,0x781e,0x781e,0x7c1e,0x3ffe,0x1ffe,0x001e,0x001e,0x001e,0x001e,0x001e,0x001e,0x0000,
  0x0000,0x07e0,0x0ff0,0x1c38,0x381c,0x781e,0x781e,0x781e,0x781e,0x7bde,0x7ffe,0x3e7c,0x1c38,0x3ff0,0x77e0,0x0000,
  0x0000,0x1ffe,0x3ffe,0x7c1e,0x781e,0x781e,0x7c1e,0x3ffe,0x1ffe,0x03de,0x079e,0x0f1e,0x1e1e,0x3c1e,0x781e,0x0000,
  0x0000,0x1ff8,0x3ffc,0x7c3e,0x781e,0x001e,0x003e,0x1ffc,0x3ff8,0x7c00,0x7800,0x781e,0x7c3e,0x3ffc,0x1ff8,0x0000,
  0x0000,0x3ffc,0x3ffc,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,
  0x0000,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x3c3c,0x1ff8,0x0ff0,0x0000,
  0x0000,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x381c,0x1c38,0x0e70,0x07e0,0x03c0,0x0180,0x0000,
  0x0000,0x781e,0x781e,0x781e,0x781e,0x781e,0x781e,0x799e,0x799e,0x799e,0x7dbe,0x7ffe,0x3ffc,0x1e78,0x0c30,0x0000,
  0x0000,0x700e,0x781e,0x3c3c,0x1e78,0x0ff0,0x07e0,0x03c0,0x03c0,0x07e0,0x0ff0,0x1e78,0x3c3c,0x781e,0x700e,0x0000,
  0x0000,0x700e,0x781e,0x3c3c,0x1e78,0x0ff0,0x07e0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,
  0x0000,0x7ffe,0x7ffe,0x7800,0x3c00,0x1e00,0x0f70,0x07e0,0x03c0,0x07e0,0x0ef0,0x0078,0x003c,0x7ffe,0x7ffe,0x0000,

  0x0000,0x03c0,0x03c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x00c0,0x03c0,0x03c0,0x0000,
  0x0000,0x0006,0x000e,0x001c,0x0038,0x0070,0x00e0,0x01c0,0x0380,0x0700,0x0e00,0x1c00,0x3800,0x7000,0x6000,0x0000,
  0x0000,0x03c0,0x03c0,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x0300,0x03c0,0x03c0,0x0000,
  0x0000,0x0180,0x03c0,0x07e0,0x0e70,0x1c38,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3ffc,0x3ffc,0x0000,
  0x0000,0x0060,0x00e0,0x01c0,0x0380,0x0700,0x0600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x1ff8,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x7ff8,0xe7f0,0x0000,0x0000,
  0x0000,0x0000,0x003c,0x003c,0x003c,0x003c,0x0ffc,0x1ffc,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x1ffc,0x0ffc,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x1ff8,0x3c3c,0x381c,0x001c,0x001c,0x381c,0x3c3c,0x1ff8,0x0ff0,0x0000,0x0000,
  0x0000,0x0000,0x3c00,0x3c00,0x3c00,0x3c00,0x3ff0,0x3ff8,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3ff8,0x3ff0,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x1ff8,0x3c3c,0x3c3c,0x3ffc,0x3ffc,0x003c,0x003c,0x1ff8,0x0ff0,0x0000,0x0000,
  0x0000,0x0000,0x0f00,0x0f80,0x03c0,0x03c0,0x3ffc,0x3ffc,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x1ff8,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3ff8,0x3ff0,0x3c00,0x3c00,0x1ff0,0x0ff0,
  0x0000,0x0000,0x003c,0x003c,0x003c,0x003c,0x0ffc,0x1ffc,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x0000,0x0000,
  0x0000,0x0000,0x03c0,0x03c0,0x0000,0x0000,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,0x0000,
  0x0000,0x0000,0x0f00,0x0f00,0x0000,0x0000,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f00,0x0f3c,0x0f3c,0x07f8,0x03f0,
  0x0000,0x0000,0x003c,0x003c,0x383c,0x1c3c,0x0e3c,0x073c,0x03fc,0x03fc,0x073c,0x0e3c,0x1c3c,0x383c,0x0000,0x0000,
  0x0000,0x0000,0x01f0,0x03e0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0fe7,0x1ffe,0x3dbc,0x3dbc,0x3dbc,0x3dbc,0x3dbc,0x3dbc,0x3dbc,0x3dbc,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0fe7,0x1ffe,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x1ff8,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x1ff8,0x0ff0,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x1ff8,0x3c3c,0x3c3c,0x1ffc,0x0ffc,0x003c,0x003c,0x003c,0x003c,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x1ff8,0x3c3c,0x3c3c,0x3ff8,0x3ff0,0x3c00,0x3c00,0x3c00,0x3c00,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0fe7,0x1ffe,0x3e3c,0x3c3c,0x003c,0x003c,0x003c,0x003c,0x003c,0x003c,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0ff0,0x0ff8,0x003c,0x003c,0x0ff8,0x1ff0,0x3c00,0x3c00,0x1ff0,0x0ff0,0x0000,0x0000,
  0x0000,0x0000,0x03c0,0x03c0,0x03c0,0x03c0,0x3ffc,0x3ffc,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3e7c,0x7ff8,0xe7f0,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x1c38,0x0ff0,0x07e0,0x03c0,0x0180,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3dbc,0x3dbc,0x3dbc,0x3ffc,0x1ff8,0x0c30,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x3c3c,0x1e78,0x0ff0,0x07e0,0x03c0,0x03c0,0x07e0,0x0ff0,0x1e78,0x3c3c,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3c3c,0x3ff8,0x3ff0,0x3c00,0x3c00,0x1ff0,0x0ff0,
  0x0000,0x0000,0x0000,0x0000,0x3ffc,0x3ffc,0x1e00,0x0f00,0x0780,0x03c0,0x01e0,0x00f0,0x3ff8,0x3ffc,0x0000,0x0000,

  0x0000,0x0600,0x0700,0x0380,0x0180,0x0180,0x01c0,0x00e0,0x00e0,0x01c0,0x0180,0x0180,0x0380,0x0700,0x0600,0x0000,
  0x0000,0x0000,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x03c0,0x0000,0x0000,
  0x0000,0x0060,0x00e0,0x01c0,0x0180,0x0180,0x0380,0x0700,0x0700,0x0380,0x0180,0x0180,0x01c0,0x00e0,0x0060,0x0000,
  0x0000,0x30f0,0x39f8,0x1f9c,0x0f0c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

};

const struct charset charset_font16x16 = {
  16, 16,
  sizeof(bitmap) / (sizeof(*bitmap) * 16),
  bitmap, IMAGE_TYPE_MONOCOLOR, (1 << 9)
};
